/*------------------------------------------------------------------------------
						SEPIA
------------------------------------------------------------------------------*/

float4 SepiaPass( float4 colorInput )
{
	float4 sepia = colorInput;
	// Calculating amounts of input, grey and sepia colors to blend and combine
	float grey = dot(sepia.rgb, float3(0.2126, 0.7152, 0.0722));
	sepia.rgb = float3(sepia.rgb * ColorTone);
	float grey2 = grey * GreyPower;
	float4 color2 = colorInput / (GreyPower + 1);
	float4 blend2 = grey2 + color2;
	sepia.rgb = lerp(blend2, sepia.rgb, SepiaPower);
	// returning the final color
	return sepia;
}